#pragma once

#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/sdk/interfaces/i_endpoint.h>
#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>

#include <memory>
#include <string>

namespace YandexIO {

    struct RemoteObjectIdFactory {
        static std::string createId(const std::shared_ptr<IEndpointStorage>& storage);
        static std::string createId(const std::shared_ptr<IEndpoint>& endpoint);
        static std::string createEndpointId(const std::string& endpointId);
        static std::string createId(const std::string& endpointId, const std::shared_ptr<ICapability>& capability);
    };

} // namespace YandexIO
