#pragma once

#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/sdk/interfaces/i_endpoint.h>
#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>

#include <yandex_io/protos/remoting.pb.h>

#include <memory>
#include <vector>

namespace YandexIO {

    struct RemotingMessageBuilder {
        // Endpoint Storage
        static quasar::proto::Remoting buildAddEndpoint(const std::shared_ptr<IEndpointStorage>& storage,
                                                        const std::string& storageName,
                                                        const quasar::proto::Endpoint& endpoint);

        static quasar::proto::Remoting buildRemoveEndpoint(const std::shared_ptr<IEndpointStorage>& storage,
                                                           const std::string& storageName,
                                                           const quasar::proto::Endpoint& endpoint);

        static quasar::proto::Remoting buildSyncEndpoints(const std::shared_ptr<IEndpointStorage>& storage,
                                                          const std::string& storageName,
                                                          const std::vector<quasar::proto::Endpoint>& endpoints);

        static quasar::proto::Remoting builCapabilityConfig(const std::shared_ptr<IEndpointStorage>& storage,
                                                            const quasar::proto::CapabilityConfig& config);

        // Endpoint
        static quasar::proto::Remoting buildAddCapability(const std::shared_ptr<IEndpoint>& endpoint,
                                                          const std::shared_ptr<ICapability>& capability,
                                                          const std::string& storageName);

        static quasar::proto::Remoting buildRemoveCapability(const std::shared_ptr<IEndpoint>& endpoint,
                                                             const std::shared_ptr<ICapability>& capability);

        static quasar::proto::Remoting buildEndpointSyncState(const std::shared_ptr<IEndpoint>& endpoint);

        // Capability
        static quasar::proto::Remoting buildCapabilityStateChanged(const std::string& endpointId,
                                                                   const std::shared_ptr<ICapability>& capability,
                                                                   const NAlice::TCapabilityHolder& state);

        static quasar::proto::Remoting buildCapabilityEvents(const std::string& endpointId,
                                                             const std::shared_ptr<ICapability>& capability,
                                                             const std::vector<NAlice::TCapabilityEvent>& events);

        // DirectiveHandler
        static quasar::proto::Remoting buildDirectiveHandlerMethod(const std::string& remoteObjectId,
                                                                   const std::shared_ptr<IDirectiveHandler>& directiveHandler,
                                                                   const std::shared_ptr<Directive>& directive,
                                                                   quasar::proto::Remoting::DirectiveHandlerMethod::Method method);
    };

} // namespace YandexIO
