#include "directive_handler_proxy.h"

#include <yandex_io/sdk/private/endpoint_storage/converters/remoting_message_builder.h>

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/protobuf_utils/proto_trace.h>

namespace YandexIO {

    DirectiveHandlerProxy::DirectiveHandlerProxy(
        std::string name,
        std::string endpointId,
        std::string remoteObjectId,
        std::set<std::string> supportedDirectiveNames,
        std::shared_ptr<IConnectionRegistry> connections,
        std::string connectionName)
        : name_(std::move(name))
        , endpointId_(std::move(endpointId))
        , remoteObjectId_(std::move(remoteObjectId))
        , supportedDirectiveNames_(std::move(supportedDirectiveNames))
        , connectionName_(std::move(connectionName))
        , connections_(std::move(connections))
    {
    }

    const std::string& DirectiveHandlerProxy::getEndpointId() const {
        return endpointId_;
    }

    const std::string& DirectiveHandlerProxy::getHandlerName() const {
        return name_;
    }

    const std::set<std::string>& DirectiveHandlerProxy::getSupportedDirectiveNames() const {
        return supportedDirectiveNames_;
    }

    void DirectiveHandlerProxy::handleDirective(const std::shared_ptr<Directive>& directive)
    {
        sendDirectiveHandlerMethod(directive, quasar::proto::Remoting::DirectiveHandlerMethod::HANDLE);
    }

    void DirectiveHandlerProxy::cancelDirective(const std::shared_ptr<Directive>& directive)
    {
        sendDirectiveHandlerMethod(directive, quasar::proto::Remoting::DirectiveHandlerMethod::CANCEL);
    }

    void DirectiveHandlerProxy::prefetchDirective(const std::shared_ptr<Directive>& directive)
    {
        sendDirectiveHandlerMethod(directive, quasar::proto::Remoting::DirectiveHandlerMethod::PREFETCH);
    }

    void DirectiveHandlerProxy::sendDirectiveHandlerMethod(
        const std::shared_ptr<Directive>& directive, quasar::proto::Remoting::DirectiveHandlerMethod::Method method) {
        const auto remoting = RemotingMessageBuilder::buildDirectiveHandlerMethod(remoteObjectId_,
                                                                                  shared_from_this(),
                                                                                  directive, method);

        YIO_LOG_DEBUG("Protobuf=" << quasar::shortUtf8DebugString(remoting));
        connections_->sendMessage(remoting, connectionName_);
    }

} // namespace YandexIO
