#pragma once

#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/endpoint_storage/connection_registry.h>

#include <memory>

namespace YandexIO {

    class DirectiveHandlerProxy: public IDirectiveHandler,
                                 public std::enable_shared_from_this<DirectiveHandlerProxy> {
    public:
        DirectiveHandlerProxy(std::string name,
                              std::string endpointId,
                              std::string remoteObjectId,
                              std::set<std::string> supportedDirectiveNames,
                              std::shared_ptr<IConnectionRegistry> connections,
                              std::string connectionName);

        const std::string& getEndpointId() const override;
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<Directive>& directive) override;

    private:
        void sendDirectiveHandlerMethod(
            const std::shared_ptr<Directive>& directive,
            quasar::proto::Remoting::DirectiveHandlerMethod::Method method);

    private:
        const std::string name_;
        const std::string endpointId_;
        const std::string remoteObjectId_;
        const std::set<std::string> supportedDirectiveNames_;
        const std::string connectionName_;
        const std::shared_ptr<IConnectionRegistry> connections_;
    };

} // namespace YandexIO
