#pragma once

#include "endpoint_base.h"
#include "capability_proxy.h"
#include "connection_registry.h"
#include "directive_handler_proxy.h"

#include <yandex_io/sdk/private/remoting/i_remote_object.h>

#include <memory>
#include <map>
#include <set>

namespace YandexIO {

    class Endpoint
        : public EndpointBase,
          public IRemoteObject,
          public std::enable_shared_from_this<Endpoint> {
    public:
        Endpoint(std::string id,
                 NAlice::TEndpoint::EEndpointType type,
                 NAlice::TEndpoint::TDeviceInfo deviceInfo,
                 std::shared_ptr<IDirectiveHandler> directiveHandler,
                 std::string storageName,
                 bool isHost,
                 std::string hostStorageName,
                 std::weak_ptr<IRemotingRegistry> remotingRegistry,
                 std::shared_ptr<IConnectionRegistry> connectionRegistry);
        ~Endpoint();

        void initRemoting();
        void initProxyCapabilities(const quasar::proto::Endpoint& message);
        void dropProxyCapabilities();
        quasar::proto::Endpoint toProto();

    public:
        // IEndpoint Api
        void addCapability(const std::shared_ptr<ICapability>& capability) override;
        void removeCapability(const std::shared_ptr<ICapability>& capability) override;
        void setStatus(const NAlice::TEndpoint::TStatus& status) override;
        std::list<std::shared_ptr<ICapability>> getCapabilities() const override;

    private:
        std::shared_ptr<IEndpoint> sharedFromThis() override;

        // IRemoteObject implementation
        //
        void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<IRemotingConnection> connection) override;

        void handleRemoteAddCapability(const quasar::proto::Remoting::EndpointMethod& method,
                                       const std::string& connectionStorageName);

        void handleRemoteRemoveCapability(const quasar::proto::Remoting::EndpointMethod& method);

        void handleRemoteSyncState(const quasar::proto::Remoting::EndpointMethod& method);

        void handleDirectiveHandlerMethod(const quasar::proto::Remoting::DirectiveHandlerMethod& method);

        void removeProxyListenerForCapability(const std::shared_ptr<ICapability>& capability);
        void addCapabilityImpl(const std::string& storageName, const std::shared_ptr<ICapability>& capability);
        void removeCapabilityImpl(const std::shared_ptr<ICapability>& capability);

        std::shared_ptr<IDirectiveHandler> findDirectiveHandler(const std::string& handlerName) const;

    private:
        // name of storage - this Endpoint (host/proxy) is installed in
        const std::string storageName_;
        // name of connection used to communicate with EndpointHost
        const std::string hostNodeConnectionName_;
        const bool isHost_;
        const std::shared_ptr<IConnectionRegistry> connections_;
        std::string remoteObjectId_;
        std::map<std::string, std::shared_ptr<ProxyCapabilityListener>> proxyListenerByCapId_;
        std::map<std::string, std::list<std::shared_ptr<ICapability>>> capabilities_;
        // todo: schedule cleaning
        std::set<std::string> outgoingRequests_;
        std::map<std::string, std::string> routedReqIdToConnection_;
    };

} // namespace YandexIO
