#pragma once

#include <yandex_io/sdk/interfaces/i_endpoint.h>

namespace YandexIO {

    class EndpointBase: public IEndpoint {
    public:
        EndpointBase(std::string id, NAlice::TEndpoint::EEndpointType type, NAlice::TEndpoint::TDeviceInfo deviceInfo, std::shared_ptr<IDirectiveHandler> directiveHandler);

        const std::string& getId() const override;
        NAlice::TEndpoint getState() const override;

        void setStatus(const NAlice::TEndpoint::TStatus& status) override;
        NAlice::TEndpoint::TStatus getStatus() const override;

        void addListener(std::weak_ptr<IListener> wlistener) override;
        void removeListener(std::weak_ptr<IListener> wlistener) override;

        std::shared_ptr<IDirectiveHandler> getDirectiveHandler() const override;

    protected:
        virtual std::shared_ptr<IEndpoint> sharedFromThis() = 0;
        void forEachListener(const std::function<void(const std::shared_ptr<IListener>)>& callback);

    private:
        const std::string id_;
        const NAlice::TEndpoint::EEndpointType type_;
        const NAlice::TEndpoint::TDeviceInfo deviceInfo_;
        const std::shared_ptr<IDirectiveHandler> directiveHandler_;
        NAlice::TEndpoint::TStatus status_;
        NAlice::TEndpoint state_;
        std::list<std::weak_ptr<IEndpoint::IListener>> wlisteners_;
    };

} // namespace YandexIO
