#pragma once

#include "connection_registry.h"
#include "endpoint.h"

#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <yandex_io/protos/remoting.pb.h>

#include <optional>
#include <unordered_map>

namespace YandexIO {

    class EndpointStorageHost
        : public IEndpointStorage,
          public IRemoteObject,
          public std::enable_shared_from_this<EndpointStorageHost> {
    public:
        EndpointStorageHost(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                            std::string deviceId,
                            NAlice::TEndpoint::EEndpointType type);
        ~EndpointStorageHost();

        void init();

        std::shared_ptr<IEndpoint> createEndpoint(std::string id, NAlice::TEndpoint::EEndpointType type, NAlice::TEndpoint::TDeviceInfo deviceInfo, std::shared_ptr<IDirectiveHandler> directiveHandler) override;
        std::shared_ptr<IEndpoint> getLocalEndpoint() const override;

        void addListener(std::weak_ptr<IListener> listener) override;
        void removeListener(std::weak_ptr<IListener> listener) override;
        void addEndpoint(const std::shared_ptr<IEndpoint>& iendpoint) override;
        void removeEndpoint(const std::shared_ptr<IEndpoint>& endpoint) override;
        std::list<std::shared_ptr<IEndpoint>> getEndpoints() const override;

        void setCapabilityConfig(quasar::proto::CapabilityConfig config);

        // IRemoteObject implementation
        //
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;

    private:
        bool addEndpointImpl(const std::shared_ptr<Endpoint>& endpoint, const std::string& storageName);
        bool removeEndpointImpl(const std::string& endpointId, const std::string& storageName);
        void removeProxyEndpoints(const std::string& proxyStorageName);
        void broadcastCapabilityConfig();
        std::shared_ptr<Endpoint> findCreatedEndpoint(const std::shared_ptr<IEndpoint>& iendpoint);
        void dropDeadCreatedEndpoints();
        void forEachListener(std::function<void(const std::shared_ptr<IEndpointStorage::IListener>&)> callback);

    private:
        std::shared_ptr<Endpoint> createEndpointProxy(
            const quasar::proto::Endpoint& message,
            const std::shared_ptr<IRemotingConnection>& connection);

    private:
        const std::string hostStorageName_{"EndpointStorageHost"};
        const std::shared_ptr<IConnectionRegistry> proxyConnections_;
        std::string remoteObjectId_;

        std::shared_ptr<Endpoint> localEndpoint_;
        std::list<std::weak_ptr<Endpoint>> createdEndpoints_;
        std::map<std::string, std::list<std::shared_ptr<Endpoint>>> endpoints_;
        std::list<std::weak_ptr<IEndpointStorage::IListener>> listeners_;
        quasar::proto::CapabilityConfig capabilityConfig_;
    };

} // namespace YandexIO
