#pragma once

#include "connection_registry.h"
#include "endpoint.h"
#include "local_endpoint.h"

#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/protos/remoting.pb.h>

namespace YandexIO {

    class EndpointStorageProxy
        : public IEndpointStorage,
          public IRemoteObject,
          public std::enable_shared_from_this<EndpointStorageProxy> {
    public:
        EndpointStorageProxy(std::string storageName,
                             std::string deviceId,
                             std::shared_ptr<quasar::ICallbackQueue> worker,
                             std::weak_ptr<IRemotingRegistry> remotingRegistry);
        ~EndpointStorageProxy();

        void start();
        void stop();

        std::shared_ptr<IEndpoint> createEndpoint(std::string id, NAlice::TEndpoint::EEndpointType type, NAlice::TEndpoint::TDeviceInfo deviceInfo, std::shared_ptr<IDirectiveHandler> directiveHandler) override;
        std::shared_ptr<IEndpoint> getLocalEndpoint() const override;

        void addListener(std::weak_ptr<IEndpointStorage::IListener> wlistener) override;
        void removeListener(std::weak_ptr<IEndpointStorage::IListener> wlistener) override;
        void addEndpoint(const std::shared_ptr<IEndpoint>& iendpoint) override;
        void removeEndpoint(const std::shared_ptr<IEndpoint>& endpoint) override;
        std::list<std::shared_ptr<IEndpoint>> getEndpoints() const override;

    private:
        bool addEndpointImpl(const std::shared_ptr<Endpoint>& endpoint, std::list<std::shared_ptr<Endpoint>>& endpoints);
        bool removeEndpointImpl(const std::string& endpointId, std::list<std::shared_ptr<Endpoint>>& endpoints);
        void syncEndpoints();
        void sendMessage(const quasar::proto::Remoting& message);
        void dropProxyEndpoints();
        std::shared_ptr<Endpoint> findCreatedEndpoint(const std::shared_ptr<IEndpoint>& iendpoint);
        void dropDeadCreatedEndpoints();
        std::shared_ptr<Endpoint> createEndpointProxy(const quasar::proto::Endpoint& message, const std::shared_ptr<IRemotingConnection>& connection);
        void forEachListener(std::function<void(const std::shared_ptr<IEndpointStorage::IListener>&)> callback);

        // IRemoteObject implementation
        //
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> /* connection */) override;

    private:
        const std::string storageName_;
        const std::shared_ptr<IConnectionRegistry> connections_;
        const std::shared_ptr<LocalEndpoint> localEndpoint_;

        std::list<std::weak_ptr<Endpoint>> createdEndpoints_;
        std::list<std::shared_ptr<Endpoint>> proxyEndpoints_;
        std::list<std::shared_ptr<Endpoint>> endpoints_;
        std::list<std::weak_ptr<IEndpointStorage::IListener>> listeners_;
        bool isStarted_ = false;
        std::optional<quasar::proto::CapabilityConfig> capabilityConfig_;
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
    };

} // namespace YandexIO
