#pragma once

#include <yandex_io/sdk/interfaces/i_endpoint.h>

#include <memory>

namespace YandexIO {

    class LocalEndpoint: public YandexIO::IEndpoint,
                         public YandexIO::IEndpoint::IListener,
                         public std::enable_shared_from_this<LocalEndpoint> {
    public:
        explicit LocalEndpoint(std::string id);
        ~LocalEndpoint();

        void setLocalEndpoint(std::shared_ptr<IEndpoint> endpoint);
        void removeLocalEndpoint();

    public:
        // IEndpoint Api
        const std::string& getId() const override;
        NAlice::TEndpoint getState() const override;

        void setStatus(const NAlice::TEndpoint::TStatus& status) override;
        NAlice::TEndpoint::TStatus getStatus() const override;

        void addCapability(const std::shared_ptr<ICapability>& capability) override;
        void removeCapability(const std::shared_ptr<ICapability>& capability) override;
        std::list<std::shared_ptr<ICapability>> getCapabilities() const override;

        void addListener(std::weak_ptr<IListener> wlistener) override;
        void removeListener(std::weak_ptr<IListener> wlistener) override;

        std::shared_ptr<IDirectiveHandler> getDirectiveHandler() const override;

    private:
        void onCapabilityAdded(const std::shared_ptr<IEndpoint>& enpdoint, const std::shared_ptr<ICapability>& capability) override;
        void onCapabilityRemoved(const std::shared_ptr<IEndpoint>& enpdoint, const std::shared_ptr<ICapability>& capability) override;
        void onEndpointStateChanged(const std::shared_ptr<IEndpoint>& endpoint) override;

    private:
        void forEachListener(std::function<void(const std::shared_ptr<IEndpoint::IListener>&)> callback);
        void removeCapabilityLocal(const std::shared_ptr<ICapability>& capability);
        const std::string id_;
        NAlice::TEndpoint state_;
        std::list<std::shared_ptr<ICapability>> capabilities_;
        std::list<std::weak_ptr<IEndpoint::IListener>> wlisteners_;

        std::shared_ptr<IEndpoint> realEndpoint_;
    };

} // namespace YandexIO
