#include "proxy_factory.h"

using namespace YandexIO;

std::shared_ptr<CapabilityProxy> YandexIO::createCapabilityProxy(const quasar::proto::Capability& message,
                                                                 std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                                                 const std::string& remoteObjectId,
                                                                 std::shared_ptr<IConnectionRegistry> connections,
                                                                 const std::string& connectionName) {
    std::shared_ptr<DirectiveHandlerProxy> directiveHandler = nullptr;
    if (message.has_directive_handler()) {
        directiveHandler = createDirectiveHandlerProxy(message.directive_handler(),
                                                       remoteObjectId,
                                                       connections,
                                                       connectionName);
    }
    return std::make_shared<CapabilityProxy>(message.id(),
                                             message.capability(),
                                             std::move(directiveHandler),
                                             std::move(remotingRegistry),
                                             std::move(connections));
}

std::shared_ptr<DirectiveHandlerProxy> YandexIO::createDirectiveHandlerProxy(const quasar::proto::DirectiveHandler& message,
                                                                             const std::string& remoteObjectId,
                                                                             std::shared_ptr<IConnectionRegistry> connections,
                                                                             std::string connectionName) {
    std::set<std::string> supportedDirectiveNames{
        message.supported_directive_names().begin(),
        message.supported_directive_names().end(),
    };

    return std::make_shared<DirectiveHandlerProxy>(message.name(),
                                                   message.endpoint_id(),
                                                   remoteObjectId,
                                                   std::move(supportedDirectiveNames),
                                                   std::move(connections),
                                                   std::move(connectionName));
}
