#pragma once

#include "capability_proxy.h"
#include "directive_handler_proxy.h"

namespace YandexIO {

    std::shared_ptr<CapabilityProxy> createCapabilityProxy(
        const quasar::proto::Capability& message,
        std::weak_ptr<IRemotingRegistry> remotingRegistry,
        const std::string& remoteObjectId,
        std::shared_ptr<IConnectionRegistry> connections,
        const std::string& connectionName);

    std::shared_ptr<DirectiveHandlerProxy> createDirectiveHandlerProxy(
        const quasar::proto::DirectiveHandler& message,
        const std::string& remoteObjectId,
        std::shared_ptr<IConnectionRegistry> connections,
        std::string connectionName);

} // namespace YandexIO
