#include "i_remote_object.h"

namespace YandexIO {

    IRemoteObject::IRemoteObject(std::weak_ptr<IRemotingRegistry> remotingRegistry)
        : remotingRegistry_(std::move(remotingRegistry))
    {
    }

    IRemoteObject::~IRemoteObject() = default;

    const std::weak_ptr<IRemotingRegistry>& IRemoteObject::getRemotingRegistry() const {
        return remotingRegistry_;
    }

    void IRemoteObject::handleRemotingConnect(std::shared_ptr<IRemotingConnection> /*connection*/) {
        // no-op by default
    }

} // namespace YandexIO
