#pragma once

#include "i_remoting_connection.h"

#include <yandex_io/protos/remoting.pb.h>

#include <memory>

namespace YandexIO {

    class IRemotingRegistry;

    class IRemoteObject {
    public:
        IRemoteObject(std::weak_ptr<IRemotingRegistry> remotingRegistry);
        virtual ~IRemoteObject();

        virtual void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<IRemotingConnection> connection) = 0;

        virtual void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection);

    protected:
        const std::weak_ptr<IRemotingRegistry>& getRemotingRegistry() const;

    private:
        std::weak_ptr<IRemotingRegistry> remotingRegistry_;
    };

} // namespace YandexIO
