#include "remoting_connector_wrapper.h"

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/protobuf_utils/debug.h>

#include <yandex_io/protos/quasar_proto.pb.h>

using namespace YandexIO;

RemotingConnectorWrapper::RemotingConnectorWrapper(quasar::ipc::IIpcFactory& ipcFactory,
                                                   const std::string& serviceName,
                                                   std::shared_ptr<quasar::ICallbackQueue> worker,
                                                   std::string logTag)
    : remotingRouter_(std::make_shared<RemotingMessageRouter>())
    , connector_(ipcFactory.createIpcConnector(serviceName))
    , worker_(std::move(worker))
    , logTag_(std::move(logTag))
{
}

RemotingConnectorWrapper::~RemotingConnectorWrapper() {
    connector_->shutdown();
}

void RemotingConnectorWrapper::start() {
    connector_->setConnectHandler([this]() {
        worker_->add([this]() {
            YIO_LOG_DEBUG("[" << logTag_ << "]: Handle Connect");
            remotingRouter_->routeRemotingConnect(connector_);
        });
    });
    connector_->setMessageHandler([this](const auto& sharedMessage) {
        worker_->add([this, sharedMessage]() {
            const auto& message = *sharedMessage;
            if (message.has_remoting()) {
                YIO_LOG_DEBUG("[" << logTag_ << "]: Protobuf=" << quasar::shortUtf8DebugString(message));
                remotingRouter_->routeRemotingMessage(message.remoting(), connector_);
            }
        });
    });
    connector_->connectToService();
}

std::weak_ptr<IRemotingRegistry> RemotingConnectorWrapper::getRemotingRegistry() const {
    return remotingRouter_;
}
