#pragma once

#include "remoting_message_router.h"

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <string>
#include <memory>

namespace YandexIO {

    class RemotingConnectorWrapper {
    public:
        RemotingConnectorWrapper(quasar::ipc::IIpcFactory& ipcFactory,
                                 const std::string& serviceName,
                                 std::shared_ptr<quasar::ICallbackQueue> worker,
                                 std::string logTag);
        ~RemotingConnectorWrapper();
        void start();
        std::weak_ptr<IRemotingRegistry> getRemotingRegistry() const;

    private:
        const std::shared_ptr<RemotingMessageRouter> remotingRouter_;
        const std::shared_ptr<quasar::ipc::IConnector> connector_;
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::string logTag_;
    };

} // namespace YandexIO
