#pragma once

#include "i_remote_object.h"
#include "i_remoting_connection.h"
#include "i_remoting_registry.h"

#include <yandex_io/libs/ipc/i_server.h>
#include <yandex_io/libs/ipc/i_connector.h>

#include <memory>
#include <unordered_map>

namespace YandexIO {

    class RemotingMessageRouter: public IRemotingRegistry {
    public:
        // IServer api
        void routeRemotingMessage(
            const quasar::proto::Remoting& message,
            const std::shared_ptr<quasar::ipc::IServer::IClientConnection>& connection);

        void routeRemotingConnect(const std::shared_ptr<quasar::ipc::IServer::IClientConnection>& connection);

        // IConnector api
        void routeRemotingMessage(
            const quasar::proto::Remoting& message,
            const std::shared_ptr<quasar::ipc::IConnector>& connection);

        void routeRemotingConnect(const std::shared_ptr<quasar::ipc::IConnector>& connection);

        // IRemotingRegistry implementation
        //
        bool addRemoteObject(const std::string& key, std::weak_ptr<IRemoteObject> object) override;
        void removeRemoteObject(const std::string& key) override;

    private:
        void routeRemotingMessageImpl(const quasar::proto::Remoting& message, const std::shared_ptr<IRemotingConnection>& connection) const;
        void routeRemotingConnectImpl(const std::shared_ptr<IRemotingConnection>& connection) const;

        std::shared_ptr<IRemotingConnection> findOrPutConnection(const std::weak_ptr<quasar::ipc::IConnector>& connection);
        std::shared_ptr<IRemotingConnection> findOrPutConnection(const std::weak_ptr<quasar::ipc::IServer::IClientConnection>& connection);

    private:
        using WeakServerCmp = std::owner_less<std::weak_ptr<quasar::ipc::IConnector>>;
        using WeakConnectorCmp = std::owner_less<std::weak_ptr<quasar::ipc::IServer::IClientConnection>>;

        std::map<std::weak_ptr<quasar::ipc::IConnector>, std::shared_ptr<IRemotingConnection>, WeakServerCmp> connectorConnections_;
        std::map<std::weak_ptr<quasar::ipc::IServer::IClientConnection>, std::shared_ptr<IRemotingConnection>, WeakConnectorCmp> serverConnections_;
        std::unordered_map<std::string, std::weak_ptr<IRemoteObject>> remoteObjects_;
    };

    class RemotingConnection: public IRemotingConnection {
    public:
        explicit RemotingConnection(std::weak_ptr<quasar::ipc::IServer::IClientConnection> connection);
        explicit RemotingConnection(std::weak_ptr<quasar::ipc::IConnector> connection);

        void sendMessage(const quasar::proto::Remoting& remoting) override;

    private:
        const std::weak_ptr<quasar::ipc::IConnector> connector_;
        const std::weak_ptr<quasar::ipc::IServer::IClientConnection> serverConnection_;
    };

} // namespace YandexIO
