#pragma once

#include <util/system/yassert.h>

#include <memory>

namespace YandexIO {

    template <typename Base, typename Listener>
    class WeakListenersStorage: public Base {
    public:
        using WeakListener = std::weak_ptr<Listener>;

        void addListener(WeakListener wlistener) override {
            Y_VERIFY(!wlistener.expired());
            wlisteners_.insert(std::move(wlistener));
        }

        void removeListener(WeakListener wlistener) override {
            wlisteners_.erase(wlistener);
        }

    protected:
        WeakListenersStorage() = default;
        ~WeakListenersStorage() = default;

        template <typename Func>
        void forEachListener(Func callback) {
            auto listeners = getActiveListeners();
            for (const auto& listener : listeners) {
                callback(listener);
            }
        }

    private:
        std::vector<std::shared_ptr<typename WeakListener::element_type>> getActiveListeners() {
            std::vector<std::shared_ptr<typename WeakListener::element_type>> listeners;
            listeners.reserve(wlisteners_.size());
            const auto listenersEnd = wlisteners_.end();
            for (auto it = wlisteners_.begin(); it != listenersEnd;) {
                if (auto listener = it->lock()) {
                    listeners.push_back(listener);
                    ++it;
                } else {
                    it = wlisteners_.erase(it);
                }
            }
            return listeners;
        }

        std::set<WeakListener, std::owner_less<WeakListener>> wlisteners_;
    };

} // namespace YandexIO
