#include "sdk_state.h"

namespace YandexIO {

    bool SDKState::PlayerState::isAudioPlaying() const {
        return audio.isPlaying || music.isPlaying || radio.isPlaying;
    }

    bool SDKState::PlayerState::isVideoPlaying() const {
        return video.isPlaying;
    }

    bool SDKState::isMediaPlaying() const {
        return playerState.isAudioPlaying() || playerState.isVideoPlaying() || multiroomState.playing;
    }

    bool SDKState::hasIncomingCall() const {
        if (callState.status == CallState::Status::NOCALL) {
            return false;
        }
        return callState.direction == CallState::Direction::INCOMING && callState.status == CallState::Status::RINGING;
    }

    bool SDKState::hasCurrentCall() const {
        if (callState.status == CallState::Status::NOCALL) {
            return false;
        }
        return callState.direction == CallState::Direction::OUTGOING || callState.status == CallState::Status::ACCEPTING || callState.status == CallState::Status::CONNECTING || callState.status == CallState::Status::CONNECTED;
    }

    std::string SDKState::aliceStateToString(SDKState::AliceState aliceState) {
        switch (aliceState.state) {
            case AliceState::State::IDLE:
                return "Idle";
            case AliceState::State::LISTENING:
                return "Listening";
            case AliceState::State::SPEAKING:
                return "Speaking";
            case AliceState::State::THINKING:
                return "Thinking";
            case AliceState::State::SHAZAM:
                return "Shazam";
            case AliceState::State::NONE:
                return "None";
            default:
                return "Unknown";
        }
    }

    std::string SDKState::configurationStateToString(SDKState::ConfigurationState configurationState) {
        switch (configurationState) {
            case ConfigurationState::CONFIGURING:
                return "Configuring";
            case ConfigurationState::CONFIGURED:
                return "Configured";
            case ConfigurationState::UNKNOWN:
            default:
                return "Unknown";
        }
    }

    std::string SDKState::updateStateToString(SDKState::UpdateState updateState) {
        switch (updateState.state) {
            case UpdateState::State::NONE:
                return "None";
            case UpdateState::State::DOWNLOADING:
                return std::string("Downloading ") + std::to_string(updateState.downloadProgress);
            case UpdateState::State::APPLYING:
                return "Applying";
            default:
                return "Unknown";
        }
    }

} /* namespace YandexIO */
