#pragma once

//
// © YANDEX LLC, 2019
//

#pragma once

#include <yandex_io/sdk/wifi_info.h>

#include <chrono>
#include <optional>
#include <string>
#include <vector>

namespace YandexIO {
    struct SDKState {
        enum class ConfigurationState {
            UNKNOWN = 0,
            CONFIGURING,
            CONFIGURED,
        };
        ConfigurationState configurationState{ConfigurationState::UNKNOWN};

        struct AliceState {
            enum class State {
                IDLE,
                LISTENING,
                SPEAKING,
                THINKING,
                SHAZAM,
                NONE,
            };
            struct VinsResponse {
                struct Suggest {
                    std::string text;
                };
                std::optional<std::string> outputSpeech = std::nullopt;
                std::vector<Suggest> suggests;
                std::optional<bool> textOnly;
                std::optional<std::string> divCard = std::nullopt;
            };

            State state{State::NONE};
            std::optional<std::string> recognizedPhrase = std::nullopt;
            std::optional<VinsResponse> vinsResponse = std::nullopt;
        };
        AliceState aliceState;

        struct AllStartupSettings {
            bool allStartupInfo = false;
            std::string authToken;
            std::string passportUid;
        };

        AllStartupSettings allStartupSettings;

        struct CallState {
            enum class Status {
                NEW,
                DIALING,
                RINGING,
                ACCEPTING,
                CONNECTING,
                CONNECTED,
                ENDED_OK,
                ENDED_FAILURE,
                NOCALL,
            };

            enum class Direction {
                OUTGOING,
                INCOMING,
            };

            Status status{Status::NOCALL};
            Direction direction{Direction::INCOMING};
        };
        CallState callState;

        bool isAlarmPlaying = false;
        bool isTimerPlaying = false;
        int32_t setAlarmsTimersCount = 0;
        std::string iCalendarState;

        struct TimerState {
            std::string id;
            std::chrono::system_clock::time_point startTs;
            std::chrono::system_clock::time_point endTs;
        };

        std::vector<TimerState> timers;

        bool isReminderPlaying{false};

        bool isDoNotDisturbMode{false};

        enum class NotificationState {
            NONE,
            AVAILABLE,
            PASSIVE
        };
        NotificationState notificationState{NotificationState::NONE};

        struct WifiState {
            bool isWifiConnected{false};
            bool isInternetReachable{false};
        };

        WifiState wifiState;
        std::vector<YandexIO::WifiInfo> wifiList;

        struct PlayerState {
            struct Audio {
                bool isPlaying{false};
            };
            struct Music {
                std::string currentTrackId;
                bool isPlaying{false};
                std::string title;
                std::string artists;
                std::string coverURL;
            };
            struct Radio {
                bool isPlaying{false};
            };
            struct Video {
                bool isPlaying{false};
            };

            bool isAudioPlaying() const;
            bool isVideoPlaying() const;

            Audio audio;
            Music music;
            Radio radio;
            Video video;
        };

        struct ScreenState {
            bool isScreensaverOn{false};
        };

        PlayerState playerState;
        ScreenState screenState;

        struct UpdateState {
            /*! State of Current Update */
            enum class State {
                NONE,        /*!< Device doesn't receive any new updates */
                DOWNLOADING, /*!< Device is downloading new OTA */
                APPLYING     /*!< Device is applying OTA update */
            };
            State state{State::NONE}; /*!< Current state of update (have update or not) */
            int downloadProgress{0};  /*!< Progress of downloading update (if State == DOWNLOADING) Value in [0..100] */
            bool isCritical{false};   /*!< Is update Critical (should be installed asap).
                                    If update not critical -> should be installed silently */
        };
        UpdateState updateState;

        struct NtpdState {
            std::optional<bool> clockSynchronized;
        };
        NtpdState ntpdState;

        enum class IotState {
            UNKNOWN = 0,
            IDLE,
            STARTING_DISCOVERY,
            DISCOVERY_IN_PROGRESS
        };
        IotState iotState{IotState::IDLE};

        struct MultiroomState {
            enum class Mode {
                NONE = 0,
                MASTER,
                SLAVE,
            };
            Mode mode{Mode::NONE};
            bool playing{false};

            enum class SyncLevel {
                NONE,
                WEAK,
                STRONG,

                UNDEFINED,
            };
            SyncLevel slaveSyncLevel{SyncLevel::UNDEFINED};
            bool slaveClockSyncing{false};
        };
        MultiroomState multiroomState;

        bool isMediaPlaying() const;

        bool hasIncomingCall() const;
        bool hasCurrentCall() const;

        static std::string aliceStateToString(AliceState aliceState);
        static std::string configurationStateToString(ConfigurationState configurationState);
        static std::string updateStateToString(UpdateState updateState);
    };

} /* namespace YandexIO */
