#pragma once

#include <chrono>
#include <vector>

namespace YandexIO {
    class SpectrumObserver {
    public:
        struct SpectrumFrame {
            std::chrono::nanoseconds runningTime;
            std::chrono::nanoseconds duration;
            int rate;
            std::vector<float> magnitudes;
            int threshold;
        };

        enum class SpectrumType {
            MUSIC,
            VOICE,
        };

        virtual void onSpectrum(int64_t playerInstanceId, const SpectrumFrame& frame, SpectrumType type) = 0;

        virtual void onSpectrumStart(int64_t playerInstanceId, SpectrumType type) = 0;
        virtual void onSpectrumPause(int64_t playerInstanceId, SpectrumType type) = 0;
        virtual void onSpectrumResume(int64_t playerInstanceId, SpectrumType type) = 0;

        virtual ~SpectrumObserver() = default;
    };

} // namespace YandexIO
