#pragma once

//
// © YANDEX LLC, 2019
//

#pragma once

namespace YandexIO {
    class UpdateObserver {
    public:
        /**
         * @brief Event that is sent on device Boot Up. This event notify if device rebooted by Update Apply or not
         * @note This event may happen only in case if updates are managed by Yandex Software
         * @param wasAttempted - true - device was rebooted because tried to apply update.
         *                       false - device was rebooted manually
         * @param attemptSucceeded - true - device successfully updated. false - update apply failed
         */
        virtual void onLastUpdateInfo(bool wasAttempted, bool attemptSucceeded) = 0;

        virtual ~UpdateObserver() = default;
    };

} // namespace YandexIO
