OWNER(g:yandex_io)

LIBRARY()

PEERDIR(
    yandex_io/capabilities/alarm
    yandex_io/capabilities/alice
    yandex_io/capabilities/file_player
    yandex_io/capabilities/playback_control
    yandex_io/capabilities/spotter
    yandex_io/capabilities/device_state/proxy
    yandex_io/libs/base
    yandex_io/libs/bluetooth
    yandex_io/libs/device
    yandex_io/libs/ipc
    yandex_io/libs/logging
    yandex_io/libs/protobuf_utils
    yandex_io/protos
    yandex_io/sdk/proto
    yandex_io/sdk/interfaces
    yandex_io/sdk/private/endpoint_storage
)

SRCS(
    audio_source/base/audio_source.cpp
    audio_source/socket/audio_source_utils.cpp
    audio_source/socket/socket_audio_source_client.cpp
    audio_source/socket/socket_audio_source.cpp
    audio_source/defines.cpp
    audio_source/i_audio_source.cpp
    audio_source/i_audio_source_client.cpp
    converters/audio_client_event_converter.cpp
    converters/glagol_discovery_result_converter.cpp
    converters/glagol_device_list_converter.cpp
    converters/wifi_info_converter.cpp
    converters/device_group_state_converter.cpp
    private/device_context.cpp
    backend_config_observer.cpp
    sdk_interface.cpp
    sdk_state.cpp
    yandex_iosdk.cpp
)

GENERATE_ENUM_SERIALIZATION(
    audio_source/feedback_source.h
)

END()


RECURSE(
    hub
    interfaces
    proto
    private/endpoint_storage
)

RECURSE_FOR_TESTS(tests)
