#pragma once

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>

#include <optional>

namespace quasar {

    class AdbService: public QuasarService {
    public:
        class Api {
        public:
            virtual ~Api() = default;
            virtual int system(const std::string& commandLine) const = 0;
        };

        AdbService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<IUserConfigProvider> userConfigProvider);
        AdbService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<IUserConfigProvider> userConfigProvider, std::shared_ptr<ICallbackQueue> lifecycle, std::shared_ptr<Api> api);
        ~AdbService();

        std::string getServiceName() const override {
            return "adbd";
        }

        void start() override;
        void stop() override;

    private:
        struct Config {
            bool forceDisable{false};
            bool remoteActivation{false};
            bool network{false};
        };

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ICallbackQueue> lifecycle_;
        const std::shared_ptr<Api> api_;
        const std::string quasmodromActivateCmd_;
        const std::string quasmodromNetworkActivateCmd_;
        const std::string quasmodromDeactivateCmd_;
        const std::string allDeactivateCmd_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;

        std::optional<Config> config_;
    };

} /* namespace quasar */
