#include "alarm_service.h"

#include <memory>

using namespace quasar;

AlarmService::AlarmService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IStereoPairProvider> stereoPairProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , stereoPairProvider_(std::move(stereoPairProvider))
{
}

std::string AlarmService::getServiceName() const {
    return "alarmd";
}

void AlarmService::start() {
    alarmEndpoint_ = std::make_unique<AlarmEndpoint>(device_, ipcFactory_, authProvider_, stereoPairProvider_);
}
