#pragma once

#include "alarm_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class AlarmService: public QuasarService {
    public:
        AlarmService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider);

        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<quasar::IAuthProvider> authProvider_;
        std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        std::unique_ptr<AlarmEndpoint> alarmEndpoint_;
    };

} // namespace quasar
