#include "alarm_utils.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <json/json.h>

#include <sstream>

using namespace quasar;

std::string quasar::alarmToJSON(const proto::Alarm& alarm)
{
    Json::Value alarmJson;

    alarmJson["id"] = alarm.id();
    alarmJson["startTimestampMs"] = alarm.start_timestamp_ms();
    alarmJson["durationSeconds"] = alarm.duration_seconds();
    alarmJson["alarmType"] = alarmTypeToString(alarm.alarm_type());
    alarmJson["delaySeconds"] = alarm.delay_seconds();
    return jsonToString(alarmJson);
}

std::string quasar::alarmTypeToString(const proto::Alarm::AlarmType& alarmType)
{
    static_assert(proto::Alarm_AlarmType_AlarmType_ARRAYSIZE == 5, "New types were added!");
    switch (alarmType) {
        case proto::Alarm::TIMER:
            return "TIMER";
        case proto::Alarm::ALARM:
            return "ALARM";
        case proto::Alarm::REMINDER:
            return "REMINDER";
        case proto::Alarm::COMMAND_TIMER:
            return "COMMAND_TIMER";
        case proto::Alarm::MEDIA_ALARM:
            return "MEDIA_ALARM";
        default:
            return "";
    }
}

std::string quasar::alarmsToString(const proto::TimersState& timersState)
{
    Json::Value res = Json::arrayValue;
    for (const auto& alarm : timersState.timers()) {
        Json::Value alarmJson;
        alarmJson["id"] = alarm.id();
        alarmJson["startTimestampMs"] = alarm.start_timestamp_ms();
        alarmJson["durationSeconds"] = alarm.duration_seconds();
        if (alarm.alarm_type() == quasar::proto::Alarm_AlarmType_TIMER) {
            alarmJson["pausedSeconds"] = alarm.paused_seconds();
            alarmJson["pauseTimestampSec"] = alarm.pause_timestamp_sec();
        } else {
            alarmJson["delaySeconds"] = alarm.delay_seconds();
        }
        res.append(alarmJson);
    }
    return jsonToString(res);
}
