#pragma once

#include "speechkit_endpoint.h"
#include "speechkit_facade/alice_audio_source.h"
#include "speechkit_facade/quasar_voice_dialog.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/sdk/audio_source/i_audio_source_client.h>
#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/speechkit_facade/random_sound_logger/random_sound_logger.h>

#include <speechkit/AudioPlayer.h>

#include <memory>
#include <string>

namespace quasar {
    class AliceService: public QuasarService {
        std::shared_ptr<NamedCallbackQueue> callbackExecutor_;
        std::shared_ptr<YandexIO::IDevice> device_;
        const NAlice::TEndpoint::EEndpointType endpointType_;
        std::shared_ptr<YandexIO::SDKInterface> sdk_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::shared_ptr<IClockTowerProvider> clockTowerProvider_;
        std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider_;
        std::shared_ptr<IMultiroomProvider> multiroomProvider_;
        std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        std::shared_ptr<SpeechkitEndpoint> dialogListener_;
        QuasarVoiceDialog::SharedPtr quasarVoiceDialog_;
        std::shared_ptr<AliceAudioSource> aliceAudioSource_;
        SpeechKit::AudioPlayer::SharedPtr speechkitAudioPlayer_;
        std::shared_ptr<YandexIO::IAudioSourceClient> ioAudioSourceClient_;
        std::shared_ptr<SelfDestroyer> selfDestroyer_;
        std::shared_ptr<RandomSoundLogger> randomSoundLogger_;
        AliceConfig aliceConfig_;
        std::shared_ptr<AliceDeviceState> aliceDeviceState_;

    public:
        AliceService(
            std::shared_ptr<YandexIO::IDevice> device,
            NAlice::TEndpoint::EEndpointType endpointType,
            std::shared_ptr<YandexIO::SDKInterface> sdk,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<quasar::IAuthProvider> authProvider,
            std::shared_ptr<IClockTowerProvider> clockTowerProvider,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
            std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider,
            std::shared_ptr<IMultiroomProvider> multiroomProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider,
            SpeechKit::AudioPlayer::SharedPtr audioPlayer,
            std::shared_ptr<SelfDestroyer> selfDestroyer);

        ~AliceService();

        std::string getServiceName() const override;

    private:
        void start() override;
    };

} // namespace quasar
