#pragma once

#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <optional>

namespace quasar {

    class AudioFocusDispatcher {
    public:
        AudioFocusDispatcher(std::shared_ptr<ipc::IConnector> toMediad,
                             std::shared_ptr<ipc::IConnector> toInterfaced,
                             std::shared_ptr<ipc::IConnector> toAudioClientd);

        void onMediadConnected();
        void onInterfacedConnected();
        void onAudioClientdConnected();
        void setAudioFocus(proto::AudioChannel channel);
        std::optional<proto::AudioChannel> getAudioFocus() const;

    private:
        void applyFocusToMediad();
        void applyFocusToAudioClientd();
        void applyFocusToInterfaced();

        void takeMediadFocus();
        void freeMediadFocus();
        void takeInterfacedFocus();
        void freeInterfacedFocus();

        std::string formatCurrentFocusChannel() const;

    private:
        std::shared_ptr<ipc::IConnector> toMediad_;
        std::shared_ptr<ipc::IConnector> toInterfaced_;
        std::shared_ptr<ipc::IConnector> toAudioClientd_;
        bool toMediadConnected_ = false;
        bool toInterfacedConnected_ = false;
        bool toAudioClientdConnected_ = false;

        std::optional<proto::AudioChannel> currentFocusedChannel_;
    };

} // namespace quasar
