#pragma once

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability_listener.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/ipc/i_server.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <list>
#include <memory>

namespace YandexIO {

    class AliceStateMachine {
    public:
        AliceStateMachine(
            std::shared_ptr<quasar::ipc::IServer> server,
            std::shared_ptr<quasar::ipc::IConnector> interfacedConnector);

        const quasar::proto::AliceState& getState() const;

        void onStartSpotting(const std::string& activationSpotterModel, bool hasAllStartupInfo);
        void onRecognitionBegin(const std::string& requestId, bool isMusic);
        void onPartialResult(const std::string& requestId, const std::string& partialResult);
        void onAliceRequest();
        void onAliceResponse(quasar::proto::VinsResponse vinsResponse);
        void onSayingBegin();
        void onHasStartupInfo(bool hasAllStartupInfo);
        void onAliceStateOverride(quasar::proto::AliceState state);
        void onTtsCompleted();

        void addListener(std::weak_ptr<IAliceCapabilityListener> listener);
        void removeListener(std::weak_ptr<IAliceCapabilityListener> listener);

    private:
        void onShazam();
        void broadcastAliceState();
        void setState(quasar::proto::AliceState newState);

    private:
        quasar::proto::AliceState aliceState_;
        const std::shared_ptr<quasar::ipc::IServer> server_;
        const std::shared_ptr<quasar::ipc::IConnector> interfacedConnector_;
        std::list<std::weak_ptr<IAliceCapabilityListener>> wlisteners_;
    };

} // namespace YandexIO
