#pragma once

#include "i_player.h"

#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <speechkit/core/include/speechkit/AudioPlayer.h>
#include <speechkit/core/include/speechkit/SoundBuffer.h>
#include <speechkit/core/include/speechkit/TTSDataProvider.h>

namespace YandexIO {

    class AudioClientTtsPlayer
        : public IPlayer,
          public SpeechKit::TTSDataProvider::Listener,
          public std::enable_shared_from_this<AudioClientTtsPlayer> {
    public:
        AudioClientTtsPlayer(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            SpeechKit::TTSDataProvider::SharedPtr ttsDataProvider,
            std::shared_ptr<quasar::ipc::IConnector> audioClientConnector,
            std::chrono::milliseconds silenceTimeAfterTts,
            std::shared_ptr<VinsRequest> request);
        ~AudioClientTtsPlayer() = default;

        void play(const quasar::proto::AudioAnalyticsContext& analyticsContext) override;
        void pause() override;
        void resume() override;
        void cancel() override;
        void handleAudioClientEvent(const quasar::proto::AudioClientEvent& event) override;
        void handleAudioClientConnectionStatus(bool connected) override;
        void setListener(std::weak_ptr<IListener> listener) override;

        void onStreamBegin() override;
        void onStreamData(SpeechKit::SoundBuffer::SharedPtr data) override;
        void onStreamEnd() override;
        void onStreamError(const SpeechKit::Error& error) override;

    private:
        void sendStream(const char* data, size_t size);
        void sendDestroyPlayer();

        void onPlayingBegin();
        void onPlayingEnd();
        void onPlayingError(const SpeechKit::Error& error);

        static quasar::proto::AudioPlayerDescriptor createDescriptor();

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        SpeechKit::TTSDataProvider::SharedPtr ttsDataProvider_;
        std::shared_ptr<quasar::ipc::IConnector> audioClientConnector_;
        quasar::proto::AudioPlayerDescriptor descriptor_;
        bool canceled_ = false;
        std::weak_ptr<IPlayer::IListener> listener_;
        const std::chrono::milliseconds silenceTimeAfterTts_;
        const std::shared_ptr<VinsRequest> request_;
        bool isStarted_ = false;
        bool isFinished_ = false;
    };

} // namespace YandexIO
