#include "directive_factory.h"

#include <yandex_io/capabilities/alice/interfaces/vins_request.h>
#include <yandex_io/services/aliced/capabilities/alice_capability/directives/alice_request_directive.h>

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

namespace YandexIO {

    std::shared_ptr<Directive> DirectiveFactory::createDirective(const quasar::proto::Directive& protobuf)
    {
        auto directive = Directive::createDirectiveFromProtobuf(protobuf);

        if (directive->getData().isServerAction()) {
            auto vinsRequest = VinsRequest::createServerActionRequest(directive->getData());
            directive = std::make_shared<AliceRequestDirective>(std::move(vinsRequest), nullptr, true);
        }

        return directive;
    }

} // namespace YandexIO
