#include "alice_request_directive.h"

#include <yandex_io/libs/base/directives.h>

namespace YandexIO {

    AliceRequestDirective::AliceRequestDirective(
        std::shared_ptr<VinsRequest> request,
        std::shared_ptr<IAliceRequestEvents> events,
        bool isRequest,
        Directive::Data originData)
        : Directive(Directive::Data("undefined", "undefined"))
        , isRequest_(isRequest)
        , request_(std::move(request))
        , events_(std::move(events))
        , originData_(std::move(originData))
    {
        switch (request_->getEventSource().type()) {
            case NAlice::TSpeechKitRequestProto_TEventSource_EType_Voice: {
                data_ = Directive::Data(quasar::Directives::LISTEN, "client_action");
                data_.channel = quasar::proto::DIALOG_CHANNEL;
                break;
            }
            case NAlice::TSpeechKitRequestProto_TEventSource_EType_Music: {
                data_ = Directive::Data(quasar::Directives::START_MUSIC_RECOGNIZER, "client_action");
                data_.channel = quasar::proto::DIALOG_CHANNEL;
                break;
            }
            default: {
                data_ = Directive::Data(quasar::Directives::ALICE_REQUEST, "server_action");
                break;
            }
        }
    }

    bool AliceRequestDirective::isRequest() const {
        return isRequest_ && !request_->getIsParallel();
    }

    const std::shared_ptr<VinsRequest>& AliceRequestDirective::getRequest() const {
        return request_;
    }

    const std::shared_ptr<IAliceRequestEvents>& AliceRequestDirective::getEvents() const {
        return events_;
    }

    quasar::proto::Directive AliceRequestDirective::toProtobuf() const {
        if (originData_.name.empty()) {
            return Directive::toProtobuf();
        }

        return Directive::convertDirectiveToProtobuf(originData_);
    }

} // namespace YandexIO
