#pragma once

#include <yandex_io/sdk/interfaces/directive.h>
#include <yandex_io/capabilities/alice/interfaces/vins_request.h>
#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>

namespace YandexIO {

    class AliceRequestDirective: public YandexIO::Directive {
    public:
        AliceRequestDirective(
            std::shared_ptr<VinsRequest> request,
            std::shared_ptr<IAliceRequestEvents> events,
            bool isRequest,
            Directive::Data originData = Directive::Data());

        bool isRequest() const override;
        quasar::proto::Directive toProtobuf() const override;
        const std::shared_ptr<VinsRequest>& getRequest() const;
        const std::shared_ptr<IAliceRequestEvents>& getEvents() const;

    private:
        bool isRequest_;
        const std::shared_ptr<VinsRequest> request_;
        const std::shared_ptr<IAliceRequestEvents> events_;
        const Directive::Data originData_;
    };

} // namespace YandexIO
