#include "play_tts_directive.h"

#include <yandex_io/libs/base/directives.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/protos/model_objects.pb.h>

using namespace YandexIO;

PlayTtsDirective::PlayTtsDirective(Directive::Data data, std::shared_ptr<IPlayer> player, bool isReminder)
    : Directive(std::move(data))
    , isReminder_(isReminder)
    , player_(std::move(player))
{
    data_.channel = parseAudioChannel();
}

std::string PlayTtsDirective::format() const {
    std::stringstream ss;
    ss << Directive::format();
    ss << ":channel=" << quasar::proto::AudioChannel_Name(getData().channel.value());

    return ss.str();
}

const std::shared_ptr<IPlayer>& PlayTtsDirective::getPlayer() const {
    return player_;
}

bool PlayTtsDirective::isReminder() const {
    return isReminder_;
}

quasar::proto::AudioChannel PlayTtsDirective::parseAudioChannel() const {
    const auto channelStr = quasar::tryGetString(getData().payload, "channel");
    if (channelStr.empty()) {
        return quasar::proto::DIALOG_CHANNEL;
    }

    if (channelStr == "Dialog") {
        return quasar::proto::DIALOG_CHANNEL;
    } else if (channelStr == "Content") {
        return quasar::proto::CONTENT_CHANNEL;
    }

    return quasar::proto::DIALOG_CHANNEL;
}
