#pragma once

#include <yandex_io/services/aliced/capabilities/alice_capability/i_player.h>

#include <yandex_io/sdk/interfaces/directive.h>

#include <speechkit/core/include/speechkit/Error.h>

#include <memory>

namespace YandexIO {

    class PlayTtsDirective: public Directive {
    public:
        PlayTtsDirective(Directive::Data data, std::shared_ptr<IPlayer> player, bool isReminder);

        std::string format() const override;
        const std::shared_ptr<IPlayer>& getPlayer() const;
        bool isReminder() const;

    private:
        quasar::proto::AudioChannel parseAudioChannel() const;

    private:
        const bool isReminder_;
        const std::shared_ptr<IPlayer> player_;
    };

} // namespace YandexIO
