#pragma once

#include <yandex_io/capabilities/alice/interfaces/vins_request.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <speechkit/core/include/speechkit/Error.h>

namespace YandexIO {

    class IPlayer {
    public:
        class IListener {
        public:
            virtual ~IListener() = default;

            virtual void onPlayingBegin(std::shared_ptr<VinsRequest> request) = 0;
            virtual void onPlayingEnd(std::shared_ptr<VinsRequest> request) = 0;
            virtual void onPlayingError(std::shared_ptr<VinsRequest> request, const SpeechKit::Error& error) = 0;
        };

    public:
        virtual ~IPlayer() = default;

        virtual void play(const quasar::proto::AudioAnalyticsContext& analyticsContext) = 0;
        virtual void pause() = 0;
        virtual void resume() = 0;
        virtual void cancel() = 0;
        virtual void handleAudioClientEvent(const quasar::proto::AudioClientEvent& event) = 0;
        virtual void handleAudioClientConnectionStatus(bool connected) = 0;
        virtual void setListener(std::weak_ptr<IListener> listener) = 0;
    };

} // namespace YandexIO
