#pragma once

#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

#include <yandex_io/sdk/interfaces/directive.h>

#include <string>
#include <vector>

namespace quasar {

    class AliceCapabilityPreprocessor: public YandexIO::IDirectivePreprocessor {
    public:
        AliceCapabilityPreprocessor(bool isBtCapability, AliceDeviceState& aliceDeviceState);

        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives) override;

    private:
        static void moveDrawLedDirectivesToBeginning(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
        void expandGoHomeDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
        std::string getPlayerPauseDirective() const;

    private:
        const bool isBtCapability_;
        const AliceDeviceState& aliceDeviceState_;
    };

} // namespace quasar
