#pragma once

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

#include <yandex_io/libs/device/device.h>
#include <yandex_io/sdk/interfaces/directive.h>

#include <string>
#include <vector>

namespace quasar {

    class LocalVinsPreprocessor: public YandexIO::IDirectivePreprocessor {
    public:
        LocalVinsPreprocessor(std::shared_ptr<YandexIO::IDevice> device);

        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives) override;

    private:
        static bool isTurnOnThereminvox(const std::string& text);
        static bool isTOFWasNotUsedToday(const std::string& text);
        static bool isStartSensorDumpToCsv(const std::string& text);
        static bool isStopSensorDumpToCsv(const std::string& text);
        static int getPositiveNumber(const std::string& text);
        static bool isFindRcu(const std::string& text);

        static bool isLavaLampTurnOn(const std::string& text);
        static bool isLavaLampTurnOff(const std::string& text);
        static bool isCandleTurnOn(const std::string& text);
        static bool isNightLampTurnOn(const std::string& text);

        static bool isZigbeeEnable(const std::string& text);
        static bool isZigbeeDisable(const std::string& text);

        static bool isIdleAnimationEnable(const std::string& text);
        static bool isIdleAnimationDisable(const std::string& text);

        static std::shared_ptr<YandexIO::Directive> createBioStartSoundEnrollment();
        static std::shared_ptr<YandexIO::Directive> createColorSceneDirective(
            const YandexIO::Directive::Data& context, bool enabled, const std::string& scene);
        static std::shared_ptr<YandexIO::Directive> createDrawSegmentAnimationDirective(
            const YandexIO::Directive::Data& context, bool isLooped, bool isDuringTTS);
        static std::shared_ptr<YandexIO::Directive> createRepeatDirective(const std::string& text);
        static std::shared_ptr<YandexIO::Directive> createExternalCommandDirective(
            const YandexIO::Directive::Data& context, const std::string& name, Json::Value payload = Json::Value());

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
    };

} // namespace quasar
