#pragma once

#include "i_player.h"

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <speechkit/core/include/speechkit/AudioPlayer.h>
#include <speechkit/core/include/speechkit/TTSDataProvider.h>

namespace YandexIO {

    class SpeechkitTtsPlayer
        : public IPlayer,
          public SpeechKit::AudioPlayer::AudioPlayerListener,
          public SpeechKit::TTSDataProvider::Listener,
          public std::enable_shared_from_this<SpeechkitTtsPlayer> {
    public:
        explicit SpeechkitTtsPlayer(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            SpeechKit::AudioPlayer::SharedPtr player,
            SpeechKit::TTSDataProvider::SharedPtr ttsDataProvider,
            std::shared_ptr<VinsRequest> request);

        void play(const quasar::proto::AudioAnalyticsContext& analyticsContext) override;
        void pause() override;
        void resume() override;
        void cancel() override;
        void handleAudioClientEvent(const quasar::proto::AudioClientEvent& /*event*/) override {
        }
        void handleAudioClientConnectionStatus(bool /*connected*/) override {
        }
        void setListener(std::weak_ptr<IListener> listener) override;

        // AudioPlayerListener interface methods
        void onPlayingBegin(SpeechKit::AudioPlayer::SharedPtr player) override;
        void onPlayingPaused(SpeechKit::AudioPlayer::SharedPtr player) override;
        void onPlayingResumed(SpeechKit::AudioPlayer::SharedPtr player) override;
        void onPlayingDone(SpeechKit::AudioPlayer::SharedPtr player) override;
        void onPlayingError(SpeechKit::AudioPlayer::SharedPtr player, const SpeechKit::Error& error) override;
        void onBufferUnderrun(SpeechKit::AudioPlayer::SharedPtr /* player */) override {
        }
        void onPlayingData(SpeechKit::AudioPlayer::SharedPtr /* player */, SpeechKit::SoundBuffer::SharedPtr /* soundBuffer */) override {
        }

        // TTSDataProvider::Listener implementation
        void onStreamBegin() override;
        void onStreamData(SpeechKit::SoundBuffer::SharedPtr data) override;
        void onStreamEnd() override;
        void onStreamError(const SpeechKit::Error& error) override;

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        SpeechKit::AudioPlayer::SharedPtr player_;
        SpeechKit::TTSDataProvider::SharedPtr dataProvider_;
        bool isStarted_ = false;
        bool isFinished_ = false;
        std::weak_ptr<IPlayer::IListener> listener_;
        const std::shared_ptr<VinsRequest> request_;
    };

} // namespace YandexIO
