#pragma once

#include <yandex_io/services/aliced/capabilities/alice_capability/i_player.h>

#include "yandex_io/capabilities/alice/interfaces/vins_request.h"
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/sdk/interfaces/directive.h>

#include <speechkit/core/include/speechkit/UniProxy.h>

#include <json/json.h>

#include <list>
#include <memory>
#include <set>
#include <string>

namespace YandexIO {

    class VinsResponse {
    public:
        bool hasMegamindError = false;
        std::list<std::shared_ptr<Directive>> directives;

    public:
        static VinsResponse parse(const std::shared_ptr<VinsRequest>& request,
                                  const SpeechKit::UniProxy::Header& header,
                                  const Json::Value& payload,
                                  std::shared_ptr<IPlayer> ttsPlayer,
                                  const std::set<std::string>& blockShowCardDirectiveNames);

        static VinsResponse parseAsyncDirectives(const SpeechKit::UniProxy::Header& header, const Json::Value& payload);

    private:
        struct Context {
            std::string requestId;
            std::string parentRequestId;
            std::string displayedText;
            std::shared_ptr<VinsRequest> request;
            std::shared_ptr<IPlayer> ttsPlayer;

            bool isReminder() const;
            bool isPrefetch() const;
            std::string getAsrText() const;
        };

        static quasar::proto::VinsResponse parseSuggests(const Json::Value& vinsPayload);
        static std::shared_ptr<Directive> createDirective(Directive::Data data, const Context& context);
        static std::shared_ptr<Directive> createDirectiveInternal(Directive::Data data, const Context& context);
        static std::shared_ptr<Directive> createListenDirective(Directive::Data data, VinsRequest::EventSource eventSource);
    };

} // namespace YandexIO
