#include "vins_utils.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <chrono>

using namespace quasar;

std::string VinsUtils::getDivCardFromVins(const Json::Value& src)
{
    if (src["card"].isNull()) {
        return "";
    }

    const Json::Value& card = src["card"];
    if (card["type"].isNull()) {
        return "";
    }

    Json::Value divResult;
    const std::string type = getString(card, "type");
    if ("div_card" == type) {
        divResult = buildDivJson(card, false);
    } else if ("div2_card" == type && !src["templates"].isNull()) {
        divResult = buildDiv2Json(card, getJson(src, "templates"));
    }

    if (divResult.empty()) {
        return "";
    }
    return jsonToString(divResult);
}

Json::Value VinsUtils::buildDivJson(const Json::Value& vinsCard, bool wrapBody)
{
    if (vinsCard["body"].isNull()) {
        return Json::nullValue;
    }

    const Json::Value& body = vinsCard["body"];
    if (wrapBody) {
        Json::Value result;
        result["card"] = body;
        return result;
    }
    return body;
}

Json::Value VinsUtils::buildDiv2Json(const Json::Value& vinsCard, const Json::Value& templates)
{
    Json::Value result = buildDivJson(vinsCard, true);
    if (!result.empty()) {
        result["templates"] = templates;
        return result;
    }
    return Json::nullValue;
}
