#pragma once

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/sdk/interfaces/directive.h>

namespace quasar {

    class AudioClientFailHandler {
    public:
        AudioClientFailHandler(YandexIO::DeviceContext& deviceContext,
                               std::shared_ptr<YandexIO::ITelemetry> telemetry,
                               std::weak_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability);

        void onVoiceInputStarted();
        void onAudioClientFailed(const YandexIO::Directive& directive);

    private:
        YandexIO::DeviceContext& deviceContext_;
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        const std::weak_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability_;

        const std::chrono::seconds errorSoundTimeout_{std::chrono::seconds(30)};
        const std::chrono::seconds errorSoundDebounce_{std::chrono::seconds(10)};
        std::chrono::steady_clock::time_point lastVoiceInputTime_;
        std::chrono::steady_clock::time_point lastAudioErrorSound_;
    };

} // namespace quasar
