#pragma once

#include "audio_client_fail_handler.h"

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <yandex_io/sdk/interfaces/directive.h>

#include <json/json.h>

namespace quasar {

    class AudioPlaySession {
    public:
        enum class BackgroundMode {
            PAUSE,
            DUCKING
        };

    public:
        AudioPlaySession(YandexIO::IDirectiveProcessorWeakPtr directiveProcessor,
                         std::shared_ptr<YandexIO::Directive> directive);

        bool wasStarted() const;
        void setWasStarted(bool value);

        bool wasPaused() const;
        void setWasPaused(bool value);

        BackgroundMode getBackgroundMode() const;
        const proto::AudioPlayerDescriptor& getDescriptor() const;

        static void reportState(const YandexIO::IDirectiveProcessorWeakPtr& directiveProcessor, const proto::AudioClientEvent& event);

    private:
        static proto::AudioPlayerDescriptor createDescriptor(const std::shared_ptr<YandexIO::Directive>& directive);
        static std::string audioClientStateToPayloadKey(proto::AudioClientState value);

    private:
        std::shared_ptr<YandexIO::Directive> directive_;
        const proto::AudioPlayerDescriptor descriptor_;
        const YandexIO::IDirectiveProcessorWeakPtr directiveProcessor_;
        bool wasStarted_ = false;
        bool wasPaused_ = false;
    };

} // namespace quasar
