#pragma once

#include "audio_client_fail_handler.h"
#include "audio_play_session.h"
#include "media_stats.h"

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability_listener.h>
#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>
#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/activity_tracker/interface/i_activity.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>

namespace quasar {

    class AudioPlayerCapability
        : public YandexIO::IDirectiveHandler,
          public YandexIO::IActivity,
          public YandexIO::IAliceCapabilityListener,
          public std::enable_shared_from_this<AudioPlayerCapability> {
    public:
        AudioPlayerCapability(YandexIO::ActivityTracker& activityTracker,
                              std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor,
                              std::shared_ptr<ipc::IConnector> audioClientConnector,
                              YandexIO::DeviceContext& deviceContext,
                              std::shared_ptr<YandexIO::IDevice> device,
                              std::weak_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability,
                              std::shared_ptr<YandexIO::IDeviceStateCapability> deviceState);

        void onQuasarMessage(const ipc::SharedMessage& sharedMessage);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void restoreDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

        // IActivity implementation
        //
        std::string activityName() const override;
        void setBackground() override;
        void setForeground() override;
        proto::AudioChannel getAudioChannel() const override;
        bool isLocal() const override;

        // IAliceCapabilityListener implementation
        void onAliceStateChanged(quasar::proto::AliceState state) override;
        void onAliceTtsCompleted() override;

    private:
        std::shared_ptr<AudioPlaySession> findActiveSession() const;
        std::shared_ptr<AudioPlaySession> findSession(const std::shared_ptr<YandexIO::Directive>& directive);
        std::shared_ptr<AudioPlaySession> findOrCreateSession(const std::shared_ptr<YandexIO::Directive>& directive);

        void onVoiceInputStarted(const std::string& vinsRequestId);
        void completeDirective(const std::shared_ptr<YandexIO::Directive>& directive);
        void onAudioClientStateChanged(const std::shared_ptr<YandexIO::Directive>& directive, const proto::AudioClientEvent& audioClientEvent);

    private:
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<ipc::IConnector> audioClientConnector_;
        const std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor_;
        const std::shared_ptr<YandexIO::IDeviceStateCapability> deviceState_;
        MediaStats mediaStats_;
        YandexIO::ActivityTracker& activityTracker_;
        YandexIO::DeviceContext& deviceContext_;
        AudioClientFailHandler audioClientFailHandler_;
        std::unordered_map<std::shared_ptr<YandexIO::Directive>, std::shared_ptr<AudioPlaySession>> sessionByDirective_;
    };

} // namespace quasar
