#pragma once

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

#include <yandex_io/sdk/interfaces/directive.h>

namespace quasar {

    class AudioPlayerPreprocessor: public YandexIO::IDirectivePreprocessor {
    public:
        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives) override;

    private:
        static void markGetNextDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
        static void injectStopOppositePlayerDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
        static bool isLegacyPlayerDirective(const std::shared_ptr<YandexIO::Directive>& directive);
        static void markAudioPlayDirectivesAsPrefetchBlockers(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
    };

} // namespace quasar
