#pragma once

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/interfaces/directive.h>

namespace quasar {

    class MediaRequestFactory {
    public:
        static ipc::SharedMessage createPlayCommand(
            const std::shared_ptr<YandexIO::Directive>& directive,
            const proto::AudioPlayerDescriptor& descriptor,
            bool isPrefetch);
        static ipc::SharedMessage createCleanCommand(const proto::AudioPlayerDescriptor& descriptor);
        static ipc::SharedMessage createRewindCommand(
            const std::shared_ptr<YandexIO::Directive>& directive,
            const proto::AudioPlayerDescriptor& descriptor);
        static ipc::SharedMessage createPauseCommand(const proto::AudioPlayerDescriptor& descriptor);
        static ipc::SharedMessage createResumeCommand(const proto::AudioPlayerDescriptor& descriptor);
        static ipc::SharedMessage createMetadataCommand(
            const std::shared_ptr<YandexIO::Directive>& directive,
            const proto::AudioPlayerDescriptor& descriptor);

    private:
        static proto::MediaRequest::RewindType jsonValueToRewindType(const std::string& value);
        static proto::Audio::Screen getScreenType(const Json::Value& payload);
        static proto::Audio::Format getFormat(const Json::Value& stream);
    };

} // namespace quasar
