#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <chrono>
#include <memory>
#include <string>
#include <optional>

namespace quasar {

    class MediaStats {
        using Clock = std::chrono::steady_clock;
        using TimePoint = Clock::time_point;

        enum class PlayerType {
            UNKNOWN_PLAYER,
            AUDIO_CLIENT,
            MUSIC_PLAYER,
        };

        struct Metrics {
            std::optional<TimePoint> voiceInputStarted;
            std::optional<TimePoint> ttsCompleted;
            std::optional<TimePoint> prevTrackFinished;
            std::string vinsRequestId;
            PlayerType playerType = PlayerType::UNKNOWN_PLAYER;
        };

    public:
        MediaStats(std::shared_ptr<YandexIO::IDevice> device);

        void onVoiceInputStarted(const std::string& vinsRequestId);
        void onTtsCompleted();
        void onAudioClientEvent(const proto::AudioClientEvent& event);
        void onLegacyPlayerStateChanged(const proto::LegacyPlayerStateChanged& event);

    private:
        void onPlayerStarted(const std::string& vinsRequestId);
        void sendMetric(const TimePoint& begin, const std::string& name) const;
        std::string formatMetricName(const std::string& name) const;

    private:
        Metrics metrics_;
        const std::shared_ptr<YandexIO::IDevice> device_;
    };

} // namespace quasar
