#pragma once

#include <alice/megamind/protos/common/device_state.pb.h>

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>

#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/activity_tracker/interface/i_activity.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/device_context.h>

namespace YandexIO {

    class BluetoothCapability
        : public IDirectiveHandler,
          public IActivity,
          public std::enable_shared_from_this<IActivity> {
    public:
        BluetoothCapability(std::shared_ptr<quasar::ICallbackQueue> worker,
                            std::shared_ptr<IDeviceStateCapability> deviceState,
                            std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
                            ActivityTracker& activityTracker,
                            YandexIO::IDirectiveProcessorWeakPtr directiveProcessor,
                            std::shared_ptr<quasar::ipc::IConnector> toInterface,
                            std::shared_ptr<quasar::ipc::IConnector> toMedia);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<Directive>& directive) override;

        // IActivity implementation
        //
        std::string activityName() const override;
        void setBackground() override;
        void setForeground() override;
        quasar::proto::AudioChannel getAudioChannel() const override;
        bool isLocal() const override;

    private:
        void resume();
        void pause();
        void next();
        void prev(bool forced);
        void providePlayerState(const quasar::proto::BluetoothSinkEvent& sinkEvent);

        void updateMetaInfo(const quasar::proto::BluetoothSinkEvent& sinkEvent);
        void updatePlayingState(const quasar::proto::BluetoothSinkEvent& sinkEvent);
        void updateConnections(const quasar::proto::BluetoothSinkEvent& sinkEvent);

        void sendPauseToInterface();
        void sendNextToInterface();
        void sendPrevToInterface();

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::shared_ptr<IDeviceStateCapability> deviceState_;

        std::set<TString> btNetworks_;
        NAlice::TDeviceState::TBluetooth state_;
        quasar::proto::BluetoothTrackMetaInfo metaInfo_;
        bool isPlaying_ = false;

        DeviceContext deviceContext_;
        ActivityTracker& activityTracker_;
        const YandexIO::IDirectiveProcessorWeakPtr directiveProcessor_;
        const std::shared_ptr<quasar::ipc::IConnector> toInterface_;
        const std::shared_ptr<quasar::ipc::IConnector> toMedia_;
    };

} // namespace YandexIO
