#pragma once

#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

namespace YandexIO {

    class BluetoothCapabilityPreprocessor: public IDirectivePreprocessor {
    public:
        BluetoothCapabilityPreprocessor(quasar::AliceDeviceState& deviceState);

        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<Directive>>& directives) override;

    private:
        void convertToBluetoothDirective(std::list<std::shared_ptr<Directive>>& directives);
        void injectBluetoothPauseToPlayCommands(std::list<std::shared_ptr<Directive>>& directives);

    private:
        quasar::AliceDeviceState& deviceState_;
    };

} // namespace YandexIO
