#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>

namespace quasar {

    class ExternalCommandCapability
        : public YandexIO::IDirectiveHandler {
    public:
        ExternalCommandCapability(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IConnector> toBugReport,
            std::shared_ptr<ipc::IConnector> toInterface,
            std::shared_ptr<ipc::IConnector> toCalld,
            std::shared_ptr<ipc::IConnector> toNotificationd);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

    private:
        void sendSystemLog(const std::string& id);

        void handleBugReport(const Json::Value& payload);
        void handleCallCommand(const Json::Value& payload);
        void handleNotification(const Json::Value& payload);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;

        std::shared_ptr<ipc::IConnector> toBugReport_;
        std::shared_ptr<ipc::IConnector> toInterface_;
        std::shared_ptr<ipc::IConnector> toCalld_;
        std::shared_ptr<ipc::IConnector> toNotificationd_;
    };

} // namespace quasar
